ORCA/M Asm65816 2.1.0

0001 A144                       title 'QD Polys             GS ROM 2.0'
0002 A144              ****************************************************************
0003 A144              *                                                              *
0004 A144              *              POLYS                                           *
0005 A144              *                                                              *
0006 A144              ****************************************************************
0007 A144
0008 A144
0009 A144              ****************************************************************
0010 A144              *                                                              *
0011 A144              *                   Copyright (C) 1985-1987                    *
0012 A144              *                   All Rights Reserved                        *
0013 A144              *                   Apple Computer, Inc.                       *
0014 A144              *                                                              *
0015 A144              ****************************************************************
0016 A144                       string asis 
0017 A144                       blanks off 
0018 A144
0019 A144
0020 A144                       include 'all.macros' 
0021 A144                       include ':QDEquates:qd.data.asm' 
0022 A144
0023 A144                       INCLUDE ':QDEquates:core.globals1' 
0024 A144                       INCLUDE ':QDEquates:core.globals2' 
0025 A144                       INCLUDE ':QDEquates:region.equs' 
0026 A144                       INCLUDE ':QDEquates:rect.equs' 
0027 A144                       INCLUDE ':QDEquates:slab.equs' 
0028 A144
0029 A144
0030 A144              ;-----------------------------------------------
0031 A144              ;
0032 A144              ;   Imported addresses
0033 A144              ;
0034 A144              ;-----------------------------------------------
0035 A144
0036 A144                       IMPORT BusyEC0 
0037 A144                       IMPORT BusyEC12 
0038 A144                       IMPORT BusyEC8 
0039 A144                       IMPORT BusyErr0 
0040 A144                       IMPORT BusyErr4 
0041 A144                       IMPORT BusyErr8 
0042 A144                       IMPORT DeRefA 
0043 A144                       IMPORT DerefB 
0044 A144                       IMPORT LocalMapPoint 
0045 A144                       IMPORT QDStart 
0046 A144                       IMPORT RetrieveRects 
0047 A144                       IMPORT SpecialNewHandle 
0048 A144                       IMPORT TestGPs 
0049 A144                       IMPORT UnlockA 
0050 A144                       IMPORT UnlockB 
0051 A144                       IMPORT oErrOut4 
0052 A144
0053 A144              ;-----------------------------------------------
0054 A144              ;
0055 A144              ;   Forward addresses and entries
0056 A144              ;
0057 A144              ;-----------------------------------------------
0058 A144
0059 A144                       ENTRY CallPoly 
0060 A144                       ENTRY EPoly 
0061 A144                       ENTRY FPoly 
0062 A144                       ENTRY FrPoly 
0063 A144                       ENTRY FrameAPoly 
0064 A144                       ENTRY IPoly 
0065 A144                       ENTRY JoinPoly 
0066 A144                       ENTRY KillPolyRegion 
0067 A144                       ENTRY MakePolyRegion 
0068 A144                       ENTRY PPoly 
0069 A144                       ENTRY PolyCheckPenVis 
0070 A144                       ENTRY RepRgnSave 
0071 A144                       ENTRY SaveRgnSave 
0072 A144
0073 A144
0074 A144
0075 A144              ;                COPY polys/draw
0076 A144              ***********************************************************
0077 A144              *
0078 A144              * FramePoly  (r : Poly)
0079 A144              *
0080 A144              *
0081 A144              ****************************************************************
0082 A144                       EXPORT FramePoly 
0083 A144              FramePoly PROC 
0084 A144              *              using PicInfo
0085 A144
0086 A144 A2 00 00              ldx   #FrameVerb
0087 A147 80 0D                 bra   JoinPoly
0088 A149
0089 A149                       ENDP 
0090 A149
0091 A149
0092 A149              ****************************************************************
0093 A149              *
0094 A149              * PaintPoly    (r : Poly)
0095 A149              *
0096 A149              *
0097 A149              ****************************************************************
0098 A149                       EXPORT PaintPoly 
0099 A149              PaintPoly PROC 
0100 A149              *              using PicInfo
0101 A149
0102 A149 A2 01 00              ldx   #PaintVerb
0103 A14C 80 08                 bra   JoinPoly
0104 A14E
0105 A14E                       ENDP 
0106 A14E
0107 A14E              ****************************************************************
0108 A14E              *
0109 A14E              * ErasePoly    (r : Poly)
0110 A14E              *
0111 A14E              *
0112 A14E              ****************************************************************
0113 A14E                       EXPORT ErasePoly 
0114 A14E              ErasePoly PROC 
0115 A14E              *              using PicInfo
0116 A14E
0117 A14E A2 02 00              ldx   #EraseVerb
0118 A151 80 03                 bra   JoinPoly
0119 A153
0120 A153                       ENDP 
0121 A153
0122 A153              ****************************************************************
0123 A153              *
0124 A153              * InvertPoly   (r : Poly)
0125 A153              *
0126 A153              *
0127 A153              ****************************************************************
0128 A153                       EXPORT InvertPoly 
0129 A153              InvertPoly PROC 
0130 A153              *              using PicInfo
0131 A153
0132 A153 A2 03 00              ldx   #InvertVerb
0133 A156              ;              let this one fall into JoinPoly
0134 A156
0135 A156                       ENDP 
0136 A156
0137 A156              ****************************************************************
0138 A156              *
0139 A156              * JoinPoly
0140 A156              *
0141 A156              * Frame, Paint, Erase and Invert Poly all use this common
0142 A156              * code by branching here with the verb in x register.
0143 A156              *
0144 A156              ****************************************************************
0145 A156                       EXPORT JoinPoly 
0146 A156              JoinPoly PROC 
0147 A156
0148 A156              OrigD    equ   1
0149 A156              RTL1     equ   OrigD+2
0150 A156              RTL2     equ   RTL1+3
0151 A156              PolyHandle equ   RTL2+3
0152 A156
0153 A156 20 AA 0F              jsr   QDStart                  ; preserves x register
0154 A159
0155 A159 A3 09                 lda   PolyHandle,s
0156 A15B 85 50                 sta   RgnHandleA
0157 A15D A3 0B                 lda   PolyHandle+2,s
0158 A15F 85 52                 sta   RgnHandleA+2
0159 A161
0160 A161 22 83 A1 FE           jsl   CallPoly                 ; verb already in x
0161 A165 AA                    tax                            ; error comes back in x
0162 A166 4C 1C FC              jmp   BusyErr4
0163 A169
0164 A169
0165 A169                       ENDP 
0166 A169
0167 A169              ****************************************************************
0168 A169              *
0169 A169              * FillPoly     (r : Poly; p : pattern)
0170 A169              *
0171 A169              *
0172 A169              ****************************************************************
0173 A169                       EXPORT FillPoly 
0174 A169              FillPoly PROC 
0175 A169              *              using PicInfo
0176 A169              *              using E0Vectors
0177 A169
0178 A169              OrigDiPoly equ   1
0179 A169              RTL1     equ   OrigDiPoly+2
0180 A169              RTL2     equ   RTL1+3
0181 A169              PatPtr   equ   RTL2+3
0182 A169              PolyHandle equ   PatPtr+4
0183 A169
0184 A169 20 AA 0F              jsr   QDStart
0185 A16C
0186 A16C 22 40 1E E0           jsl   UserPat2ZP
0187 A170
0188 A170 A3 0D                 lda   PolyHandle,s
0189 A172 85 50                 sta   RgnHandleA
0190 A174 A3 0F                 lda   PolyHandle+2,s
0191 A176 85 52                 sta   RgnHandleA+2
0192 A178
0193 A178 A2 04 00              ldx   #FillVerb
0194 A17B 22 83 A1 FE           jsl   CallPoly
0195 A17F AA                    tax   
0196 A180 4C 48 FC              jmp   BusyErr8
0197 A183                       ENDP 
0198 A183
0199 A183
0200 A183
0201 A183              ****************************************************************
0202 A183              *
0203 A183              * CallPoly
0204 A183              *
0205 A183              * This routine is jumped (or branched) to by the
0206 A183              * entry points after the graf verb is loaded into the
0207 A183              * x register.
0208 A183              *
0209 A183              * Zero page is already switched in by the time it gets here.
0210 A183              *
0211 A183              ****************************************************************
0212 A183                       EXPORT CallPoly 
0213 A183              CallPoly PROC 
0214 A183              *              using CoreDATA
0215 A183              *              using PicInfo
0216 A183              *              using QDProcs
0217 A183              *              using E0Vectors
0218 A183
0219 A183 86 38                 stx   DrawVerb
0220 A185
0221 A185 20 C3 0F              jsr   TestGPs                  ; if there is a gp pointer
0222 A188 B0 04                 bcs   UseLocal
0223 A18A
0224 A18A 5C 1C 1E E0           jml   StdPoly
0225 A18E
0226 A18E
0227 A18E 8B           UseLocal phb                            ; put extra byte on stack
0228 A18F A0 18 00              ldy   #o_stdPoly               ; get adr of new Poly routine
0229 A192 B7 2A                 lda   [temp],y                 ; put on stack
0230 A194 48                    pha   
0231 A195 C8                    iny                            ; get bytes 2 and 3
0232 A196 B7 2A                 lda   [temp],y
0233 A198 83 02                 sta   2,s                      ; store middle byte twice
0234 A19A 6B                    rtl                            ; call it
0235 A19B
0236 A19B                       ENDP 
0237 A19B
0238 A19B
0239 A19B              ****************************************************************
0240 A19B              *
0241 A19B              * StdPoly
0242 A19B              *
0243 A19B              * Common Polyangle routine that is central point for
0244 A19B              * all Polyangle drawing routines.
0245 A19B              *
0246 A19B              * When control gets here, all inputs are on zero page.
0247 A19B              *       ThePoly handle is in RgnHandleA
0248 A19B              *       ThePat (if any) is in TheFillPat
0249 A19B              *       WhatToDo is in DrawVerb
0250 A19B              *
0251 A19B              ****************************************************************
0252 A19B                       EXPORT iStdPoly 
0253 A19B              iStdPoly PROC 
0254 A19B              *              using CoreDATA
0255 A19B              *              using PicInfo
0256 A19B              *              using QDProcs
0257 A19B              *              using E0Vectors
0258 A19B
0259 A19B A9 70 00              lda   #PolyNoun                ;
0260 A19E 22 F8 1E E0           jsl   PutPictStuff             ; inputs on zp and in a-reg
0261 A1A2 90 01                 bcc   NoPicError
0262 A1A4 6B                    rtl                            ; return error
0263 A1A5
0264 A1A5
0265 A1A5              NoPicError                              ; 
0266 A1A5 A5 38                 lda   DrawVerb                 ; put verb in a
0267 A1A7 F0 0E                 beq   FrPoly
0268 A1A9
0269 A1A9
0270 A1A9 3A           NotFrame dec   a
0271 A1AA 0A                    asl   a
0272 A1AB AA                    tax   
0273 A1AC 7C AF A1              jmp   (DoPolyTable,x)
0274 A1AF
0275 A1AF              DoPolyTable                             ; 
0276 A1AF BE A1                 DC W:PPoly
0277 A1B1 D4 A1                 DC W:EPoly
0278 A1B3 EA A1                 DC W:IPoly
0279 A1B5 00 A2                 DC W:FPoly
0280 A1B7
0281 A1B7                       ENDP 
0282 A1B7
0283 A1B7
0284 A1B7              ****************************************************************
0285 A1B7              *
0286 A1B7              * FrPoly
0287 A1B7              *
0288 A1B7              * Change History
0289 A1B7              * 7/23/87      GCP     Removed check for pen visibility.
0290 A1B7              *                      Returns error from FrameAPoly
0291 A1B7              *
0292 A1B7              ****************************************************************
0293 A1B7                       EXPORT FrPoly 
0294 A1B7              FrPoly   PROC 
0295 A1B7              *              using E0Vectors
0296 A1B7
0297 A1B7 A5 50                 lda   RgnHandleA
0298 A1B9 A6 52                 ldx   RgnHandleA+2
0299 A1BB 20 C5 A2              jsr   FrameAPoly
0300 A1BE
0301 A1BE                       ENDP 
0302 A1BE
0303 A1BE
0304 A1BE
0305 A1BE
0306 A1BE              ****************************************************************
0307 A1BE              *
0308 A1BE              * PPoly
0309 A1BE              *
0310 A1BE              * Change history
0311 A1BE              * 7/23/87      GCP     Now calls PolyCheckPenVis not CheckPenVis
0312 A1BE              *                      Replaced oops with bcs RepRgnSave
0313 A1BE              *
0314 A1BE              ****************************************************************
0315 A1BE                       EXPORT PPoly 
0316 A1BE              PPoly    PROC 
0317 A1BE              *              using E0Vectors
0318 A1BE
0319 A1BE 20 16 A2              jsr   PolyCheckPenVis          ; don't come back unless visible
0320 A1C1
0321 A1C1 20 3B A2              jsr   SaveRgnSave
0322 A1C4
0323 A1C4 20 5D A2              jsr   MakePolyRegion           ; make the temp region
0324 A1C7 B0 5B                 bcs   RepRgnSave               ; error so quit.
0325 A1C9 22 1C 1F E0           jsl   v_PRgn
0326 A1CD 48                    pha                            ; save error code
0327 A1CE 20 B9 A2              jsr   KillPolyRegion           ; get rid of temp region
0328 A1D1 68                    pla                            ; get error code back
0329 A1D2
0330 A1D2 80 50                 bra   RepRgnSave
0331 A1D4
0332 A1D4                       ENDP 
0333 A1D4
0334 A1D4
0335 A1D4
0336 A1D4
0337 A1D4              ****************************************************************
0338 A1D4              *
0339 A1D4              * EPoly
0340 A1D4              *
0341 A1D4              * Change History
0342 A1D4              * 7/23/87      GCP     Now calls PolyCheckPenVis not CheckPenVis
0343 A1D4              *                      Replaced oops with bcs RepRgnSave
0344 A1D4              *
0345 A1D4              ****************************************************************
0346 A1D4                       EXPORT EPoly 
0347 A1D4              EPoly    PROC 
0348 A1D4              *              using CoreDATA
0349 A1D4              *              using PenModeDATA
0350 A1D4              *              using E0Vectors
0351 A1D4
0352 A1D4 20 16 A2              jsr   PolyCheckPenVis          ; don't come back unless visible
0353 A1D7
0354 A1D7 20 3B A2              jsr   SaveRgnSave
0355 A1DA
0356 A1DA 20 5D A2              jsr   MakePolyRegion
0357 A1DD B0 45                 bcs   RepRgnSave
0358 A1DF 22 20 1F E0           jsl   v_ERgn
0359 A1E3 48                    pha   
0360 A1E4 20 B9 A2              jsr   KillPolyRegion
0361 A1E7 68                    pla   
0362 A1E8
0363 A1E8 80 3A                 bra   RepRgnSave
0364 A1EA
0365 A1EA
0366 A1EA
0367 A1EA                       ENDP 
0368 A1EA
0369 A1EA
0370 A1EA
0371 A1EA              ****************************************************************
0372 A1EA              *
0373 A1EA              * IPoly
0374 A1EA              *
0375 A1EA              * Change History
0376 A1EA              * 7/23/87      GCP     Now calls PolyCheckPenVis not CheckPenVis
0377 A1EA              *                      Replaced oops with bcs RepRgnSave
0378 A1EA              *
0379 A1EA              *
0380 A1EA              ****************************************************************
0381 A1EA                       EXPORT IPoly 
0382 A1EA              IPoly    PROC 
0383 A1EA              *              using CoreDATA
0384 A1EA              *              using PenModeDATA
0385 A1EA              *              using E0Vectors
0386 A1EA
0387 A1EA 20 16 A2              jsr   PolyCheckPenVis          ; don't come back unless visible
0388 A1ED
0389 A1ED 20 3B A2              jsr   SaveRgnSave
0390 A1F0
0391 A1F0 20 5D A2              jsr   MakePolyRegion
0392 A1F3 B0 2F                 bcs   RepRgnSave
0393 A1F5 22 24 1F E0           jsl   v_IRgn
0394 A1F9 48                    pha   
0395 A1FA 20 B9 A2              jsr   KillPolyRegion
0396 A1FD 68                    pla   
0397 A1FE
0398 A1FE 80 24                 bra   RepRgnSave
0399 A200
0400 A200
0401 A200
0402 A200                       ENDP 
0403 A200
0404 A200
0405 A200
0406 A200              ****************************************************************
0407 A200              *
0408 A200              * FPoly
0409 A200              *
0410 A200              * Change History
0411 A200              * 7/23/87      GCP     Now checks pen visibility first.
0412 A200              *                      Replaced oops with bcs RepRgnSave
0413 A200              *                      Falls through to RepRgnSave
0414 A200              *
0415 A200              *
0416 A200              ****************************************************************
0417 A200                       EXPORT FPoly 
0418 A200              FPoly    PROC 
0419 A200              *              using CoreData
0420 A200              *              using PenModeDATA
0421 A200              *              using E0Vectors
0422 A200
0423 A200 20 16 A2              jsr   PolyCheckPenVis
0424 A203
0425 A203 20 3B A2              jsr   SaveRgnSave
0426 A206
0427 A206 20 5D A2              jsr   MakePolyRegion
0428 A209 B0 19                 bcs   RepRgnSave
0429 A20B 22 28 1F E0           jsl   v_FRgn
0430 A20F 48                    pha   
0431 A210 20 B9 A2              jsr   KillPolyRegion
0432 A213 68                    pla   
0433 A214 80 0E                 bra   RepRgnSave
0434 A216
0435 A216
0436 A216                       ENDP 
0437 A216
0438 A216
0439 A216
0440 A216              ****************************************************************
0441 A216              *
0442 A216              * PolyCheckPenVis
0443 A216              *
0444 A216              * Change history
0445 A216              * 7/23/87      GCP       imported routine from patches.
0446 A216              *
0447 A216              ****************************************************************
0448 A216
0449 A216                       EXPORT PolyCheckPenVis 
0450 A216              PolyCheckPenVis PROC 
0451 A216              *              using CoreData
0452 A216              *              using PicInfo
0453 A216              *              using QDProcs
0454 A216
0455 A216
0456 A216
0457 A216 A0 72 00              ldy   #o_PnVis
0458 A219 B7 24                 lda   [PortRef],y
0459 A21B 10 06                 bpl   IsVis
0460 A21D
0461 A21D FA                    plx                            ;get rts off stack
0462 A21E A9 00 00              lda   #0                       ;clear error code
0463 A221 18                    clc                            ;clear carry
0464 A222 6B                    rtl                            ;done
0465 A223
0466 A223 60           IsVis    rts   
0467 A224
0468 A224                       ENDP 
0469 A224
0470 A224
0471 A224
0472 A224              ****************************************************************
0473 A224              *
0474 A224              * RepRgnSave
0475 A224              *
0476 A224              * Restores the region save field in the graf port from the stack
0477 A224              * while preserving the error code in a-reg.  Carry is set
0478 A224              * before final RTL which is the RTL for the drawing call.
0479 A224              *
0480 A224              ****************************************************************
0481 A224                       EXPORT RepRgnSave 
0482 A224              RepRgnSave PROC 
0483 A224              *              using CoreDATA
0484 A224 AA                    tax   
0485 A225
0486 A225 A0 72 00              ldy   #o_PnVis
0487 A228 68                    pla   
0488 A229 97 24                 sta   [PortRef],y
0489 A22B
0490 A22B
0491 A22B A0 94 00              ldy   #o_RgnSave
0492 A22E 68                    pla   
0493 A22F 97 24                 sta   [PortRef],y
0494 A231 C8                    iny   
0495 A232 C8                    iny   
0496 A233 68                    pla   
0497 A234 97 24                 sta   [PortRef],y
0498 A236
0499 A236 8A                    txa   
0500 A237
0501 A237 C9 01 00              cmp   #1
0502 A23A 6B                    rtl                            ; this ends the poly draw call with
0503 A23B              *			; error (if any) in a reg
0504 A23B
0505 A23B                       ENDP 
0506 A23B
0507 A23B
0508 A23B              ****************************************************************
0509 A23B              *
0510 A23B              * SaveRgnSave
0511 A23B              *
0512 A23B              * Puts the contents of the RgnSave field of the GrafPort
0513 A23B              * on the stack above the RTS address and zeros the RgnSave
0514 A23B              * field in the port.  This way a new region can be opened,
0515 A23B              * created and closed even if a region is already being saved.
0516 A23B              *
0517 A23B              ****************************************************************
0518 A23B                       EXPORT SaveRgnSave 
0519 A23B              SaveRgnSave PROC 
0520 A23B              *              using CoreDATA
0521 A23B FA                    plx                            ; put rts adr in x
0522 A23C
0523 A23C A0 96 00              ldy   #o_RgnSave+2             ; put the rgnsave on stack and
0524 A23F B7 24                 lda   [PortRef],y              ; zero that loc in the port
0525 A241 48                    pha   
0526 A242 88                    dey   
0527 A243 88                    dey   
0528 A244 B7 24                 lda   [PortRef],y
0529 A246 48                    pha   
0530 A247 A9 00 00              lda   #0
0531 A24A 97 24                 sta   [PortRef],y
0532 A24C C8                    iny   
0533 A24D C8                    iny   
0534 A24E 97 24                 sta   [PortRef],y
0535 A250
0536 A250 A0 72 00              ldy   #o_PnVis                 ; Save the pen level and set it
0537 A253 B7 24                 lda   [PortRef],y              ; to zero so open region will hide it
0538 A255 48                    pha                            ; close rgn will restore it and let
0539 A256 A9 00 00              lda   #0                       ; poly be painted
0540 A259 97 24                 sta   [PortRef],y
0541 A25B
0542 A25B DA                    phx                            ; restore rts adr
0543 A25C 60                    rts   
0544 A25D
0545 A25D                       ENDP 
0546 A25D
0547 A25D
0548 A25D
0549 A25D
0550 A25D
0551 A25D              ****************************************************************
0552 A25D              *
0553 A25D              * MakePolyRegion
0554 A25D              *
0555 A25D              * RgnHandleA contains handle to the polygon.  I need to open
0556 A25D              * a region, draw lines that make up the points of the polygon,
0557 A25D              * close the region and put the handle to it in RgnHandleA.
0558 A25D              *
0559 A25D              * Change History
0560 A25D              * 7/23/87      GCP     Added PullCloseAndDie to adjust the stack
0561 A25D              *                      when NewRgn fails.
0562 A25D              *
0563 A25D              ****************************************************************
0564 A25D                       EXPORT MakePolyRegion 
0565 A25D              MakePolyRegion PROC 
0566 A25D              *              using CoreDATA
0567 A25D
0568 A25D D4 52                 pei   RgnHandleA+2             ; save this on the stack
0569 A25F D4 50                 pei   RgnHandleA
0570 A261
0571 A261
0572 A261 A2 04 6D 22           _OpenRgn                       ; open the regions
0573 A268 90 03                 bcc   cont1
0574 A26A
0575 A26A FA                    plx                            ; clean stack and quit
0576 A26B FA                    plx   
0577 A26C 60                    rts   
0578 A26D
0579 A26D 68           cont1    pla   
0580 A26E FA                    plx   
0581 A26F
0582 A26F 20 C5 A2              jsr   FrameAPoly
0583 A272 B0 25                 bcs   CloseAndDie
0584 A274
0585 A274
0586 A274 F4 00 00 F4           PushLong #0 
0587 A27A A2 04 67 22           _NewRgn 
0588 A281 B0 14                 bcs   PullCloseAndDie
0589 A283
0590 A283 A3 03        cont2    lda   3,s
0591 A285 48                    pha   
0592 A286 A3 03                 lda   3,s
0593 A288 48                    pha   
0594 A289
0595 A289 A2 04 6E 22           _CloseRgn 
0596 A290
0597 A290 FA                    plx                            ; preserve any error and status
0598 A291 86 70                 stx   RgnHandleC               ; and quit
0599 A293 FA                    plx   
0600 A294 86 72                 stx   RgnHandleC+2
0601 A296
0602 A296
0603 A296 60                    rts   
0604 A297
0605 A297
0606 A297              PullCloseAndDie                         ; ; pull invalid rgn handle from stack
0607 A297
0608 A297 FA                    plx   
0609 A298 FA                    plx   
0610 A299              ; fall through
0611 A299
0612 A299              CloseAndDie                             ; 
0613 A299 48                    pha   
0614 A29A
0615 A29A A0 96 00              ldy   #o_RgnSave+2
0616 A29D B7 24                 lda   [PortRef],y
0617 A29F 48                    pha   
0618 A2A0 A9 00 00              lda   #0
0619 A2A3 97 24                 sta   [PortRef],y
0620 A2A5 88                    dey   
0621 A2A6 88                    dey   
0622 A2A7 B7 24                 lda   [PortRef],y
0623 A2A9 48                    pha   
0624 A2AA A9 00 00              lda   #0
0625 A2AD 97 24                 sta   [PortRef],y
0626 A2AF A2 02 10 22           _DisposeHandle 
0627 A2B6
0628 A2B6 68           FinishDie pla   
0629 A2B7 38                    sec   
0630 A2B8 60                    rts   
0631 A2B9
0632 A2B9                       ENDP 
0633 A2B9
0634 A2B9
0635 A2B9              ****************************************************************
0636 A2B9              *
0637 A2B9              * KillPolyRegion
0638 A2B9              *
0639 A2B9              * Kills the region whose handle is in RgnHandleC
0640 A2B9              *
0641 A2B9              ****************************************************************
0642 A2B9                       EXPORT KillPolyRegion 
0643 A2B9              KillPolyRegion PROC 
0644 A2B9
0645 A2B9 D4 72                 pei   RgnHandleC+2
0646 A2BB D4 70                 pei   RgnHandleC
0647 A2BD A2 04 68 22           _DisposeRgn 
0648 A2C4
0649 A2C4 60                    rts   
0650 A2C5
0651 A2C5                       ENDP 
0652 A2C5
0653 A2C5
0654 A2C5
0655 A2C5
0656 A2C5              ****************************************************************
0657 A2C5              *
0658 A2C5              * FrameAPoly
0659 A2C5              *
0660 A2C5              * Frames the polygon whose handle is passed in the a and x
0661 A2C5              * registers.
0662 A2C5              *
0663 A2C5              * Change History
0664 A2C5              * 7/23/87      GCP     a reg returns correct error code when no error occurs.
0665 A2C5              *
0666 A2C5              ****************************************************************
0667 A2C5                       EXPORT FrameAPoly 
0668 A2C5              FrameAPoly PROC 
0669 A2C5
0670 A2C5
0671 A2C5 DA                    phx                            ; push handle on stack
0672 A2C6 48                    pha   
0673 A2C7 48                    pha                            ; push 2 extra words on stack
0674 A2C8 48                    pha   
0675 A2C9 0B                    phd                            ; push direct register on stack
0676 A2CA
0677 A2CA 3B                    tsc                            ; get stack ptr
0678 A2CB 5B                    tcd                            ; turn stack to zp
0679 A2CC
0680 A2CC              OridDirect equ   1
0681 A2CC              PolyPtr  equ   3
0682 A2CC              PolyHandle equ   7
0683 A2CC
0684 A2CC A0 04 00              ldy   #4                       ; dereference and lock the handle
0685 A2CF B7 07                 lda   [PolyHandle],y
0686 A2D1 09 00 80              ora   #$8000
0687 A2D4 97 07                 sta   [PolyHandle],y
0688 A2D6
0689 A2D6 A7 07                 lda   [PolyHandle]
0690 A2D8 85 03                 sta   PolyPtr
0691 A2DA 88                    dey   
0692 A2DB 88                    dey   
0693 A2DC B7 07                 lda   [PolyHandle],y
0694 A2DE 85 05                 sta   PolyPtr+2
0695 A2E0
0696 A2E0
0697 A2E0 A9 0A 00              lda   #10
0698 A2E3 C7 03                 cmp   [PolyPtr]                ; see if there are any points in the
0699 A2E5 B0 55                 bcs   AllDone
0700 A2E7
0701 A2E7 A8                    tay                            ; starting with first point move there
0702 A2E8 B7 03                 lda   [PolyPtr],y
0703 A2EA AA                    tax   
0704 A2EB C8                    iny   
0705 A2EC C8                    iny   
0706 A2ED B7 03                 lda   [PolyPtr],y
0707 A2EF C8                    iny   
0708 A2F0 C8                    iny   
0709 A2F1 5A                    phy                            ; save y on stack
0710 A2F2 48                    pha   
0711 A2F3 DA                    phx   
0712 A2F4 A2 04 3A 22           _MoveTo 
0713 A2FB
0714 A2FB
0715 A2FB
0716 A2FB 68           PolyLoop pla                            ; see if there are any more points
0717 A2FC C7 03                 cmp   [PolyPtr]
0718 A2FE B0 2A                 bcs   NoMorePoints
0719 A300
0720 A300 A8                    tay                            ; draw a line to the next point
0721 A301 B7 03                 lda   [PolyPtr],y
0722 A303 AA                    tax   
0723 A304 C8                    iny   
0724 A305 C8                    iny   
0725 A306 B7 03                 lda   [PolyPtr],y
0726 A308 C8                    iny   
0727 A309 C8                    iny   
0728 A30A 5A                    phy   
0729 A30B 48                    pha   
0730 A30C DA                    phx   
0731 A30D A2 04 3C 22           _LineTo 
0732 A314 90 E5                 bcc   PolyLoop
0733 A316
0734 A316              ;----------------------------------------------------
0735 A316              ;
0736 A316              ; An error occured during lineto so I must clean up
0737 A316              ; and quit
0738 A316 7A                    ply                            ; get rid of y on stack
0739 A317 48                    pha                            ; save error code
0740 A318
0741 A318 A0 04 00              ldy   #4                       ; unlock the handle
0742 A31B B7 07                 lda   [PolyHandle],y
0743 A31D 29 FF 7F              and   #$7FFF
0744 A320 97 07                 sta   [PolyHandle],y
0745 A322
0746 A322 68                    pla                            ; get error back
0747 A323
0748 A323 2B                    pld                            ; clean up the stack
0749 A324 FA                    plx   
0750 A325 FA                    plx   
0751 A326 FA                    plx   
0752 A327 FA                    plx   
0753 A328
0754 A328 38                    sec                            ; set carry to signify error
0755 A329 60                    rts   
0756 A32A
0757 A32A
0758 A32A A0 0C 00     NoMorePoints ldy   #12                  ; close it up by drawing line back
0759 A32D B7 03                 lda   [PolyPtr],y              ; to first point.
0760 A32F 48                    pha   
0761 A330 88                    dey   
0762 A331 88                    dey   
0763 A332 B7 03                 lda   [PolyPtr],y
0764 A334 48                    pha   
0765 A335 A2 04 3C 22           _LineTo 
0766 A33C
0767 A33C
0768 A33C              AllDone                                 ; 
0769 A33C A0 04 00              ldy   #4                       ; unlock the handle
0770 A33F B7 07                 lda   [PolyHandle],y
0771 A341 29 FF 7F              and   #$7FFF
0772 A344 97 07                 sta   [PolyHandle],y
0773 A346
0774 A346 2B                    pld                            ; clean up the stack
0775 A347 68                    pla   
0776 A348 68                    pla   
0777 A349 68                    pla   
0778 A34A FA                    plx   
0779 A34B
0780 A34B A9 00 00              lda   #0                       ;no error
0781 A34E 18                    clc   
0782 A34F
0783 A34F 60                    rts   
0784 A350
0785 A350                       ENDP 
0786 A350              ;                COPY polys/make
0787 A350              ****************************************************************
0788 A350              *
0789 A350              * OpenPoly
0790 A350              *
0791 A350              *         Space For Result  : handle
0792 A350              *
0793 A350              * Checks to see if another poly is already open.  If yes returns
0794 A350              * an error. If no then gets a new handle to 256 bytes of mem,
0795 A350              * inits that mem with a length of 10 at beginning and zero
0796 A350              * bounding box.
0797 A350              *
0798 A350              ****************************************************************
0799 A350                       EXPORT OpenPoly 
0800 A350              OpenPoly PROC 
0801 A350              *              using CoreDATA
0802 A350              *              using ErrorDATA
0803 A350
0804 A350
0805 A350              OrigDirect equ   1
0806 A350              RTL1Adr  equ   OrigDirect+2
0807 A350              RTL2Adr  equ   RTL1Adr+3
0808 A350              ResultH  equ   RTL2Adr+3
0809 A350
0810 A350 20 AA 0F              jsr   QDStart
0811 A353
0812 A353 A0 98 00              ldy   #o_PolySave
0813 A356 B7 24                 lda   [PortRef],y
0814 A358 C8                    iny   
0815 A359 C8                    iny   
0816 A35A 17 24                 ora   [PortRef],y
0817 A35C F0 06                 beq   continue
0818 A35E
0819 A35E A2 40 04              ldx   #PolyAlreadyOpen
0820 A361 4C ED FB              jmp   BusyErr0
0821 A364
0822 A364
0823 A364              continue                                ; 
0824 A364
0825 A364 A9 00 01              lda   #256
0826 A367 A6 0A                 ldx   UserID
0827 A369 A0 00 00              ldy   #0
0828 A36C 20 3B 13              jsr   SpecialNewHandle
0829 A36F 90 04                 bcc   Cont2
0830 A371
0831 A371 AA                    tax                            ; move error code to x
0832 A372 4C ED FB              jmp   BusyErr0                 ; get out
0833 A375
0834 A375              cont2                                   ; 
0835 A375 86 50                 stx   RgnHandleA
0836 A377 84 52                 sty   RgnHandleA+2
0837 A379 A0 98 00              ldy   #o_PolySave
0838 A37C 8A                    txa   
0839 A37D 97 24                 sta   [PortRef],y
0840 A37F C8                    iny   
0841 A380 C8                    iny   
0842 A381 A5 52                 lda   RgnHandleA+2
0843 A383 97 24                 sta   [PortRef],y
0844 A385
0845 A385 20 7D 5A              jsr   DeRefA
0846 A388
0847 A388 A9 0A 00              lda   #10                      ; put length of 10 in first word
0848 A38B 87 54                 sta   [RgnPtrA]
0849 A38D A0 02 00              ldy   #2                       ; zero the bounding box
0850 A390 A9 00 00              lda   #0
0851 A393 97 54        ZeroLoop sta   [RgnPtrA],y
0852 A395 C8                    iny   
0853 A396 C8                    iny   
0854 A397 C0 0A 00              cpy   #10
0855 A39A 90 F7                 bcc   ZeroLoop
0856 A39C
0857 A39C A5 50                 lda   RgnhandleA               ; put result handle on stack
0858 A39E 83 09                 sta   ResultH,s
0859 A3A0 A5 52                 lda   RgnHandleA+2
0860 A3A2 83 0B                 sta   ResultH+2,s
0861 A3A4
0862 A3A4 20 93 5A              jsr   UnlockA                  ; unlock a
0863 A3A7
0864 A3A7 A2 04 27 22           _HidePen 
0865 A3AE
0866 A3AE 4C EA FB              jmp   BusyEC0                  ; all done.
0867 A3B1
0868 A3B1                       ENDP 
0869 A3B1
0870 A3B1
0871 A3B1              ****************************************************************
0872 A3B1              *
0873 A3B1              * ClosePoly
0874 A3B1              *
0875 A3B1              *
0876 A3B1              ****************************************************************
0877 A3B1                       EXPORT ClosePoly 
0878 A3B1              ClosePoly PROC 
0879 A3B1              *              using CoreDATA
0880 A3B1              *              using ErrorDATA
0881 A3B1
0882 A3B1 20 AA 0F              jsr   QDStart
0883 A3B4
0884 A3B4 A0 98 00              ldy   #o_PolySave              ; get poly handle to zp
0885 A3B7 B7 24                 lda   [PortRef],y              ; and zero the poly save field of
0886 A3B9 85 50                 sta   RgnHandleA               ; graf port.
0887 A3BB A9 00 00              lda   #0
0888 A3BE 97 24                 sta   [PortRef],y
0889 A3C0 C8                    iny   
0890 A3C1 C8                    iny   
0891 A3C2 B7 24                 lda   [PortRef],y
0892 A3C4 85 52                 sta   RgnHandleA+2
0893 A3C6 A9 00 00              lda   #0
0894 A3C9 97 24                 sta   [PortRef],y
0895 A3CB
0896 A3CB A5 50                 lda   RgnHandleA
0897 A3CD 05 52                 ora   RgnHandleA+2
0898 A3CF D0 06                 bne   cont0
0899 A3D1
0900 A3D1 A2 41 04              ldx   #PolyNotOpen
0901 A3D4 4C ED FB              jmp   BusyErr0
0902 A3D7
0903 A3D7 20 7D 5A     cont0    jsr   DerefA
0904 A3DA
0905 A3DA A7 54                 lda   [RgnPtrA]
0906 A3DC F4 00 00              pea   0
0907 A3DF 48                    pha   
0908 A3E0 D4 52                 pei   RgnHandleA+2
0909 A3E2 D4 50                 pei   RgnHandleA
0910 A3E4
0911 A3E4 20 93 5A              jsr   UnlockA
0912 A3E7
0913 A3E7 A2 02 19 22           _SetHandleSize 
0914 A3EE 90 04                 bcc   cont1
0915 A3F0
0916 A3F0 AA                    tax   
0917 A3F1 4C ED FB              jmp   BusyErr0
0918 A3F4
0919 A3F4              cont1                                   ; 
0920 A3F4              ;----------------------------------------------------
0921 A3F4              ;
0922 A3F4              ; Here I scan through the points and
0923 A3F4              ; make the bounding box.
0924 A3F4              ;
0925 A3F4 20 7D 5A              jsr   DerefA                   ; relock and deref the rgn
0926 A3F7
0927 A3F7 A7 54                 lda   [RgnPtrA]                ; if this is an empty polygon,
0928 A3F9 C9 0A 00              cmp   #10                      ; then there is no bounding box
0929 A3FC F0 52                 beq   NeverMind
0930 A3FE
0931 A3FE A0 0A 00              ldy   #10                      ; seed the bounding box with the
0932 A401 B7 54                 lda   [RgnPtrA],y              ; first point
0933 A403 85 A6                 sta   Y1
0934 A405 85 AA                 sta   Y2
0935 A407 C8                    iny   
0936 A408 C8                    iny   
0937 A409 B7 54                 lda   [RgnPtrA],y
0938 A40B 85 A8                 sta   X1
0939 A40D 85 AC                 sta   X2
0940 A40F
0941 A40F A0 0E 00              ldy   #14                      ; start with second point.
0942 A412              *			; it is impossible to have a poly that
0943 A412              *			; is only 14 long so its okay to check
0944 A412              *			; termination of loop at end.
0945 A412
0946 A412              BBLoop                                  ; 
0947 A412 B7 54                 lda   [RgnPtrA],y              ; Get Y value of point
0948 A414 C5 A6                 cmp   Y1                       ; compare to upper
0949 A416 10 02                 bpl   Y1Ok                     ; greater than upper
0950 A418 85 A6                 sta   Y1                       ; less than upper so replace upper
0951 A41A C5 AA        Y1OK     cmp   Y2                       ; now check bottom
0952 A41C 30 02                 bmi   Y2OK                     ; its less than bottom
0953 A41E 85 AA                 sta   Y2                       ; its greater so replace it
0954 A420 C8           Y2OK     iny                            ; bump y to get x value
0955 A421 C8                    iny   
0956 A422 B7 54                 lda   [RgnPtrA],y
0957 A424 C5 A8                 cmp   X1                       ; compare to left edge
0958 A426 10 02                 bpl   X1OK                     ; greater than left
0959 A428 85 A8                 sta   X1                       ; less than left so replace
0960 A42A C5 AC        X1OK     cmp   X2                       ; compare to right edge
0961 A42C 30 02                 bmi   X2OK                     ; less than right
0962 A42E 85 AC                 sta   X2                       ; greater than right so replace
0963 A430 C8           X2OK     iny                            ; bump y again
0964 A431 C8                    iny   
0965 A432
0966 A432 98                    tya                            ; compare to poly size
0967 A433 C7 54                 cmp   [RgnPtrA]                ; less, so continue
0968 A435 90 DB                 bcc   BBLoop
0969 A437
0970 A437              ;----------------------------------------------------
0971 A437              ;
0972 A437              ; Now bounds is complete, so put it in polygon.
0973 A437              ;
0974 A437 A0 02 00              ldy   #2
0975 A43A A5 A6                 lda   Y1
0976 A43C 97 54                 sta   [RgnPtrA],y
0977 A43E A5 A8                 lda   X1
0978 A440 C8                    iny   
0979 A441 C8                    iny   
0980 A442 97 54                 sta   [RgnPtrA],y
0981 A444 A5 AA                 lda   Y2
0982 A446 C8                    iny   
0983 A447 C8                    iny   
0984 A448 97 54                 sta   [RgnPtrA],y
0985 A44A A5 AC                 lda   X2
0986 A44C C8                    iny   
0987 A44D C8                    iny   
0988 A44E 97 54                 sta   [RgnPtrA],y
0989 A450
0990 A450 20 93 5A     NeverMind jsr   UnlockA
0991 A453
0992 A453 A2 04 28 22           _ShowPen 
0993 A45A
0994 A45A 4C EA FB              jmp   BusyEC0
0995 A45D
0996 A45D
0997 A45D                       ENDP 
0998 A45D
0999 A45D
1000 A45D
1001 A45D              ****************************************************************
1002 A45D              *
1003 A45D              * KillPoly
1004 A45D              *
1005 A45D              *              PolyHandle : handle
1006 A45D              *
1007 A45D              *
1008 A45D              * Change History
1009 A45D              *
1010 A45D              * 25 Feb 87    Steven Glass
1011 A45D              *
1012 A45D              * Routine used busy end call even though it did not start
1013 A45D              * by incrementing the busy flag: result in net dec of
1014 A45D              * busy flag.  Now uses non-busy end call.
1015 A45D              *
1016 A45D              ****************************************************************
1017 A45D                       EXPORT KillPoly 
1018 A45D              KillPoly PROC 
1019 A45D              *              using CoreDATA
1020 A45D              *              using ErrorDATA
1021 A45D
1022 A45D
1023 A45D              RTL1Adr  equ   1
1024 A45D              RTL2Adr  equ   RTL1Adr+3
1025 A45D              PolyH    equ   RTL2Adr+3
1026 A45D
1027 A45D A3 07                 lda   PolyH,s
1028 A45F AA                    tax   
1029 A460 A3 09                 lda   PolyH+2,s
1030 A462 48                    pha   
1031 A463 DA                    phx   
1032 A464 A2 02 10 22           _DisposeHandle 
1033 A46B
1034 A46B AA                    tax   
1035 A46C 4C 12 FC              jmp   oErrOut4
1036 A46F
1037 A46F                       ENDP 
1038 A46F
1039 A46F
1040 A46F
1041 A46F              ****************************************************************
1042 A46F              *
1043 A46F              * OffsetPoly
1044 A46F              *
1045 A46F              *              PolyHandle : handle
1046 A46F              *              dh         : word
1047 A46F              *              dv         : word
1048 A46F              *
1049 A46F              ****************************************************************
1050 A46F                       EXPORT OffsetPoly 
1051 A46F              OffsetPoly PROC 
1052 A46F              OrigDirect equ   1
1053 A46F              RTL1     equ   OrigDirect+2
1054 A46F              RTL2     equ   RTL1+3
1055 A46F              dV       equ   RTL2+3
1056 A46F              dH       equ   dV+2
1057 A46F              PolyHandle equ   dH+2
1058 A46F
1059 A46F 20 AA 0F              jsr   QDStart
1060 A472
1061 A472 A3 0D                 lda   PolyHandle,s
1062 A474 85 50                 sta   RgnHandleA
1063 A476 A3 0F                 lda   PolyHandle+2,s
1064 A478 85 52                 sta   RgnHandleA+2
1065 A47A
1066 A47A 20 7D 5A              jsr   DerefA
1067 A47D
1068 A47D A0 02 00              ldy   #2
1069 A480
1070 A480 B7 54        OffsetLoop lda   [RgnPtrA],y
1071 A482 18                    clc   
1072 A483 63 09                 adc   dV,s
1073 A485 97 54                 sta   [RgnPtrA],y
1074 A487
1075 A487 C8                    iny   
1076 A488 C8                    iny   
1077 A489 B7 54                 lda   [RgnPtrA],y
1078 A48B 18                    clc   
1079 A48C 63 0B                 adc   dH,s
1080 A48E 97 54                 sta   [RgnPtrA],y
1081 A490
1082 A490 C8                    iny   
1083 A491 C8                    iny   
1084 A492 98                    tya   
1085 A493
1086 A493 C7 54                 cmp   [RgnPtrA]
1087 A495 90 E9                 bcc   OffsetLoop
1088 A497
1089 A497
1090 A497 20 93 5A     AllDone  jsr   UnlockA
1091 A49A
1092 A49A 4C 45 FC              jmp   BusyEC8
1093 A49D
1094 A49D
1095 A49D                       ENDP 
1096 A49D
1097 A49D
1098 A49D              ****************************************************************
1099 A49D              *
1100 A49D              * MapPoly
1101 A49D              *
1102 A49D              *              PolyHandle   : handle
1103 A49D              *              SrcRect      : rectptr
1104 A49D              *              DestRect     : rectPtr
1105 A49D              *
1106 A49D              ****************************************************************
1107 A49D                       EXPORT MapPoly 
1108 A49D              MapPoly  PROC 
1109 A49D
1110 A49D              OrigDirect equ   1
1111 A49D              RTL1     equ   OrigDirect+2
1112 A49D              RTL2     equ   RTL1+3
1113 A49D              ToRectPtr equ   RTL2+3
1114 A49D              FromRectPtr equ   ToRectPtr+4
1115 A49D              PolyHandle equ   FromRectPtr+4
1116 A49D
1117 A49D
1118 A49D              *              using E0Vectors
1119 A49D
1120 A49D 20 AA 0F              jsr   QDStart
1121 A4A0
1122 A4A0 20 AA 7A              jsr   RetrieveRects            ; get the rects where they're neede
1123 A4A3
1124 A4A3 22 C8 1F E0           jsl   >SetScaleAndMap          ; set up the mapping values
1125 A4A7
1126 A4A7 A3 11                 lda   PolyHandle,s             ; get the poly handle into B
1127 A4A9 85 60                 sta   RgnHandleB
1128 A4AB A3 13                 lda   PolyHandle+2,s
1129 A4AD 85 62                 sta   RgnHandleB+2
1130 A4AF
1131 A4AF 20 9E 5A              jsr   DerefB                   ; lock and deref the poly
1132 A4B2
1133 A4B2 F4 02 00              PushWord #2                    ; put starting point on stack
1134 A4B5
1135 A4B5 A3 01        MapLoop  lda   1,s                      ; get current offset in poly
1136 A4B7 C7 64                 cmp   [RgnPtrB]                ; compare to size of polygon
1137 A4B9 B0 0E                 bcs   AllDone                  ; if greater than or equal then done
1138 A4BB
1139 A4BB A8                    tay                            ; otherwise put this in y and map the
1140 A4BC 20 D5 7B              jsr   LocalMapPoint            ; point that it points to
1141 A4BF
1142 A4BF A3 01                 lda   1,s                      ; now bump this pointer by 4 and
1143 A4C1 18                    clc                            ; continue the loop.
1144 A4C2 69 04 00              adc   #4
1145 A4C5 83 01                 sta   1,s
1146 A4C7 80 EC                 bra   MapLoop
1147 A4C9
1148 A4C9 68           AllDone  pla                            ; clear the counter off the stack
1149 A4CA
1150 A4CA 20 B4 5A              jsr   UnlockB                  ; unlock the polygon
1151 A4CD
1152 A4CD 4C 71 FC              jmp   BusyEC12                 ; goodbye.
1153 A4D0                       ENDP 
1154 A4D0
1155 A4D0
1156 A4D0
1157 A4D0              ****************************************************************
1158 A4D0              *
1159 A4D0              * AddToPoly
1160 A4D0              *
1161 A4D0              * Internal routine to determine if we are save in the process
1162 A4D0              * of defining a polygon.  If we are, then we add the point
1163 A4D0              * in Y2,X2 to the polygon definition.
1164 A4D0              *
1165 A4D0              * Modifications:
1166 A4D0              *
1167 A4D0              *    April 7, 1986     Zeros accumulator and clc's carry if no
1168 A4D0              *                      error on exit.  returns errors from
1169 A4D0              *                      memmgr calls.
1170 A4D0              *
1171 A4D0              *    May 2, 1986       Checks to see if open/close can handle
1172 A4D0              *                      this many points.  If it cannot handle
1173 A4D0              *                      the line, it is ignored and error
1174 A4D0              *                      returned.
1175 A4D0              *
1176 A4D0              ****************************************************************
1177 A4D0                       EXPORT iAddToPoly 
1178 A4D0              iAddToPoly PROC 
1179 A4D0              *              using CoreDATA
1180 A4D0              *              using ErrorData
1181 A4D0
1182 A4D0 A0 98 00              ldy   #o_PolySave
1183 A4D3 B7 24                 lda   [PortRef],y
1184 A4D5 85 50                 sta   RgnHandleA
1185 A4D7 C8                    iny   
1186 A4D8 C8                    iny   
1187 A4D9 B7 24                 lda   [PortRef],y
1188 A4DB 85 52                 sta   RgnHandleA+2
1189 A4DD 05 50                 ora   RgnHandleA
1190 A4DF D0 05                 bne   MustAdd
1191 A4E1
1192 A4E1
1193 A4E1 18                    clc   
1194 A4E2 A9 00 00              lda   #0
1195 A4E5 6B                    rtl   
1196 A4E6
1197 A4E6              MustAdd                                 ; 
1198 A4E6 20 7D 5A              jsr   DerefA                   ; deref the handle to get at data
1199 A4E9
1200 A4E9              ;----------------------------------------------------
1201 A4E9              ;
1202 A4E9              ; Figure out if open/close rgn can handle this point
1203 A4E9              ;
1204 A4E9              ; First figure number of point sets this line will
1205 A4E9              ; contribute.
1206 A4E9              ;
1207 A4E9              ;      Num = MinOF (ABS (x2-x1), ABS (y2-y1)) + 1
1208 A4E9              ;
1209 A4E9              ; except when line is vertical when Num = 0
1210 A4E9              ;
1211 A4E9 A5 AC                 lda   x2
1212 A4EB 38                    sec   
1213 A4EC E5 A8                 sbc   x1
1214 A4EE 10 04                 bpl   NotNegX
1215 A4F0 49 FF FF              eor   #$FFFF
1216 A4F3 1A                    inc   a
1217 A4F4 85 2A        NotNegX  sta   temp
1218 A4F6
1219 A4F6 A5 AA                 lda   y2                       ; if line is vertical
1220 A4F8 38                    sec                            ; there is not point sets
1221 A4F9 E5 A6                 sbc   y1                       ; added
1222 A4FB F0 52                 beq   ItWillFit
1223 A4FD 10 04                 bpl   NotNegY
1224 A4FF 49 FF FF              eor   #$FFFF
1225 A502 1A                    inc   a
1226 A503 C5 2A        NotNegY  cmp   temp
1227 A505 90 02                 bcc   YisLess
1228 A507 A5 2A                 lda   temp
1229 A509 1A           YisLess  inc   a
1230 A50A
1231 A50A A0 02 00              ldy   #2
1232 A50D 18                    clc   
1233 A50E 77 54                 adc   [RgnPtrA],y
1234 A510 97 54                 sta   [RgnPtrA],y
1235 A512
1236 A512              ;----------------------------------------------------
1237 A512              ;
1238 A512              ; Now see how many more it will be to close it
1239 A512              ; up from here.
1240 A512              ;
1241 A512 A7 54                 lda   [RgnPtrA]                ; if this is first point
1242 A514 C9 0A 00              cmp   #10                      ; don't bother.
1243 A517 F0 36                 beq   ItWillFit
1244 A519
1245 A519
1246 A519 A0 0C 00              ldy   #12
1247 A51C B7 54                 lda   [RgnPtrA],y
1248 A51E 38                    sec   
1249 A51F E5 AC                 sbc   x2
1250 A521 10 04                 bpl   NotNegX2
1251 A523 49 FF FF              eor   #$FFFF
1252 A526 1A                    inc   a
1253 A527 85 2A        NotNegX2 sta   temp
1254 A529
1255 A529 88                    dey   
1256 A52A 88                    dey   
1257 A52B B7 54                 lda   [RgnPtrA],y
1258 A52D 38                    sec   
1259 A52E E5 AA                 sbc   y2
1260 A530 10 04                 bpl   NotNegY2
1261 A532 49 FF FF              eor   #$FFFF
1262 A535 1A                    inc   a
1263 A536 C5 2A        NotNegY2 cmp   temp
1264 A538 90 02                 bcc   YisLess2
1265 A53A A5 2A                 lda   temp
1266 A53C 1A           YisLess2 inc   a
1267 A53D
1268 A53D A0 02 00              ldy   #2
1269 A540 18                    clc   
1270 A541 77 54                 adc   [RgnPtrA],y
1271 A543 C9 F8 1F              cmp   #$2000-8
1272 A546 90 07                 bcc   ItWillFit
1273 A548
1274 A548 20 93 5A              jsr   UnlockA
1275 A54B
1276 A54B A9 42 04              lda   #PolyTooBig              ; signal error
1277 A54E              ;              sec		; carry already set, save a byte.
1278 A54E 6B                    rtl   
1279 A54F
1280 A54F F4 00 00 F4  ItWillFit PushLong #0                   ; find the handle size
1281 A555 D4 52                 pei   RgnHandleA+2
1282 A557 D4 50                 pei   RgnHandleA
1283 A559 A2 02 18 22           _GetHandleSize 
1284 A560 90 04                 bcc   GotSize
1285 A562 FA                    plx   
1286 A563 FA                    plx   
1287 A564 80 56                 bra   oops
1288 A566
1289 A566 68           GotSize  pla                            ; handle size in a
1290 A567 FA                    plx   
1291 A568 38                    sec   
1292 A569 E9 04 00              sbc   #4                       ; need room for at least 4 bytes
1293 A56C C7 54                 cmp   [RgnPtrA]
1294 A56E 90 2F                 bcc   TooSmall
1295 A570 F0 2D                 beq   TooSmall
1296 A572
1297 A572              NowAddPoints                            ; 
1298 A572 A7 54                 lda   [RgnPtrA]                ; this is offset for next point
1299 A574 C9 0A 00              cmp   #10
1300 A577 D0 0E                 bne   NotFirst                 ; if equal to 10 then this is 1st pt
1301 A579
1302 A579 A8                    tay                            ; put in y and add the starting
1303 A57A A5 A6                 lda   Y1                       ; point
1304 A57C 97 54                 sta   [RgnPtrA],y
1305 A57E C8                    iny   
1306 A57F C8                    iny   
1307 A580 A5 A8                 lda   X1
1308 A582 97 54                 sta   [RgnPtrA],y
1309 A584 C8                    iny   
1310 A585 C8                    iny   
1311 A586 98                    tya   
1312 A587
1313 A587
1314 A587 A8           NotFirst tay                            ; put in y and add ending point of line
1315 A588 A5 AA                 lda   Y2
1316 A58A 97 54                 sta   [RgnPtrA],y
1317 A58C C8                    iny   
1318 A58D C8                    iny   
1319 A58E A5 AC                 lda   X2
1320 A590 97 54                 sta   [RgnPtrA],y
1321 A592 C8                    iny   
1322 A593 C8                    iny   
1323 A594 98                    tya   
1324 A595 87 54                 sta   [RgnPtrA]
1325 A597
1326 A597 20 93 5A              jsr   UnlockA                  ; unlock the handle and quit
1327 A59A
1328 A59A 18                    clc   
1329 A59B A9 00 00              lda   #0
1330 A59E 6B                    rtl   
1331 A59F
1332 A59F 18           TooSmall clc                            ; bump by decent amount
1333 A5A0 69 04 01              adc   #256+4
1334 A5A3 F4 00 00              pea   0                        ; Push the parameters for setting
1335 A5A6 48                    pha                            ; handles size on the stack
1336 A5A7 D4 52                 pei   RgnHandleA+2
1337 A5A9 D4 50                 pei   RgnHandleA
1338 A5AB 20 93 5A              jsr   UnlockA                  ; unlock the handle before making this
1339 A5AE A2 02 19 22           _SetHandleSize                 ; call.
1340 A5B5 B0 05                 bcs   Oops                     ; an error
1341 A5B7 20 7D 5A              jsr   DerefA                   ; relock and deref.
1342 A5BA 80 B6                 bra   NowAddPoints             ; now go add the points.
1343 A5BC
1344 A5BC
1345 A5BC              Oops                                    ; 
1346 A5BC 6B                    rtl                            ; if get error just quit now, can't
1347 A5BD              *			; add any more points
1348 A5BD
1349 A5BD                       ENDP 
1350 A5BD
1351 A5BD
1352 A5BD                       END   
